/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client.container.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBlockPos;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableByte;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableFloat;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableFluidStack;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.container.sync.SyncableRegistryEntry;
import mekanism.common.inventory.container.sync.SyncableShort;
import mekanism.common.inventory.container.sync.chemical.SyncableGasStack;
import mekanism.common.inventory.container.sync.chemical.SyncableInfusionStack;
import mekanism.common.inventory.container.sync.chemical.SyncablePigmentStack;
import mekanism.common.inventory.container.sync.chemical.SyncableSlurryStack;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.network.to_client.container.property.BlockPosPropertyData;
import mekanism.common.network.to_client.container.property.BooleanPropertyData;
import mekanism.common.network.to_client.container.property.BytePropertyData;
import mekanism.common.network.to_client.container.property.DoublePropertyData;
import mekanism.common.network.to_client.container.property.FloatPropertyData;
import mekanism.common.network.to_client.container.property.FloatingLongPropertyData;
import mekanism.common.network.to_client.container.property.FluidStackPropertyData;
import mekanism.common.network.to_client.container.property.FrequencyPropertyData;
import mekanism.common.network.to_client.container.property.IntPropertyData;
import mekanism.common.network.to_client.container.property.ItemStackPropertyData;
import mekanism.common.network.to_client.container.property.LongPropertyData;
import mekanism.common.network.to_client.container.property.PropertyData;
import mekanism.common.network.to_client.container.property.RegistryEntryPropertyData;
import mekanism.common.network.to_client.container.property.ShortPropertyData;
import mekanism.common.network.to_client.container.property.chemical.GasStackPropertyData;
import mekanism.common.network.to_client.container.property.chemical.InfusionStackPropertyData;
import mekanism.common.network.to_client.container.property.chemical.PigmentStackPropertyData;
import mekanism.common.network.to_client.container.property.chemical.SlurryStackPropertyData;
import mekanism.common.network.to_client.container.property.list.ListPropertyData;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum PropertyType {
    BOOLEAN(Boolean.TYPE, false, (getter, setter) -> SyncableBoolean.create(() -> PropertyType.lambda$static$0((Supplier)getter), setter::accept), (property, buffer) -> new BooleanPropertyData((short)property, buffer.readBoolean())),
    BYTE(Byte.TYPE, (byte)0, (getter, setter) -> SyncableByte.create(() -> PropertyType.lambda$static$3((Supplier)getter), setter::accept), (property, buffer) -> new BytePropertyData((short)property, buffer.readByte())),
    DOUBLE(Double.TYPE, 0.0, (getter, setter) -> SyncableDouble.create(() -> PropertyType.lambda$static$6((Supplier)getter), setter::accept), (property, buffer) -> new DoublePropertyData((short)property, buffer.readDouble())),
    FLOAT(Float.TYPE, Float.valueOf(0.0f), (getter, setter) -> SyncableFloat.create(() -> PropertyType.lambda$static$9((Supplier)getter), setter::accept), (property, buffer) -> new FloatPropertyData((short)property, buffer.readFloat())),
    INT(Integer.TYPE, 0, (getter, setter) -> SyncableInt.create(() -> PropertyType.lambda$static$12((Supplier)getter), setter::accept), (property, buffer) -> new IntPropertyData((short)property, buffer.m_130242_())),
    LONG(Long.TYPE, 0L, (getter, setter) -> SyncableLong.create(() -> PropertyType.lambda$static$15((Supplier)getter), setter::accept), (property, buffer) -> new LongPropertyData((short)property, buffer.m_130258_())),
    SHORT(Short.TYPE, (short)0, (getter, setter) -> SyncableShort.create(() -> PropertyType.lambda$static$18((Supplier)getter), setter::accept), (property, buffer) -> new ShortPropertyData((short)property, buffer.readShort())),
    REGISTRY_ENTRY(IForgeRegistryEntry.class, null, (supplier, consumer) -> SyncableRegistryEntry.create(supplier, consumer), RegistryEntryPropertyData::readRegistryEntry),
    ITEM_STACK(ItemStack.class, ItemStack.f_41583_, (getter, setter) -> SyncableItemStack.create(() -> PropertyType.lambda$static$22((Supplier)getter), setter::accept), (property, buffer) -> new ItemStackPropertyData((short)property, buffer.m_130267_())),
    FLUID_STACK(FluidStack.class, FluidStack.EMPTY, (getter, setter) -> SyncableFluidStack.create(() -> PropertyType.lambda$static$25((Supplier)getter), setter::accept), (property, buffer) -> new FluidStackPropertyData((short)property, buffer.readFluidStack())),
    GAS_STACK(GasStack.class, GasStack.EMPTY, (getter, setter) -> SyncableGasStack.create(() -> PropertyType.lambda$static$28((Supplier)getter), setter::accept), (property, buffer) -> new GasStackPropertyData((short)property, ChemicalUtils.readGasStack(buffer))),
    INFUSION_STACK(InfusionStack.class, InfusionStack.EMPTY, (getter, setter) -> SyncableInfusionStack.create(() -> PropertyType.lambda$static$31((Supplier)getter), setter::accept), (property, buffer) -> new InfusionStackPropertyData((short)property, ChemicalUtils.readInfusionStack(buffer))),
    PIGMENT_STACK(PigmentStack.class, PigmentStack.EMPTY, (getter, setter) -> SyncablePigmentStack.create(() -> PropertyType.lambda$static$34((Supplier)getter), setter::accept), (property, buffer) -> new PigmentStackPropertyData((short)property, ChemicalUtils.readPigmentStack(buffer))),
    SLURRY_STACK(SlurryStack.class, SlurryStack.EMPTY, (getter, setter) -> SyncableSlurryStack.create(() -> PropertyType.lambda$static$37((Supplier)getter), setter::accept), (property, buffer) -> new SlurryStackPropertyData((short)property, ChemicalUtils.readSlurryStack(buffer))),
    FREQUENCY(Frequency.class, null, (getter, setter) -> SyncableFrequency.create(() -> PropertyType.lambda$static$40((Supplier)getter), setter::accept), FrequencyPropertyData::readFrequency),
    LIST(ArrayList.class, Collections.emptyList(), (getter, setter) -> null, ListPropertyData::readList),
    BLOCK_POS(BlockPos.class, null, (getter, setter) -> SyncableBlockPos.create(() -> PropertyType.lambda$static$43((Supplier)getter), setter::accept), (property, buffer) -> new BlockPosPropertyData((short)property, BasePacketHandler.readOptional(buffer, FriendlyByteBuf::m_130135_))),
    FLOATING_LONG(FloatingLong.class, FloatingLong.ZERO, (getter, setter) -> SyncableFloatingLong.create(() -> PropertyType.lambda$static$46((Supplier)getter), setter::accept), (property, buffer) -> new FloatingLongPropertyData((short)property, FloatingLong.readFromBuffer(buffer)));

    private final Class<?> type;
    private final Object defaultValue;
    private final BiFunction<Supplier<Object>, Consumer<Object>, ISyncableData> creatorFunction;
    private final BiFunction<Short, FriendlyByteBuf, PropertyData> dataCreatorFunction;
    private static final PropertyType[] VALUES;

    private PropertyType(Class<?> type, Object defaultValue, BiFunction<Supplier<Object>, Consumer<Object>, ISyncableData> creatorFunction, BiFunction<Short, FriendlyByteBuf, PropertyData> dataCreatorFunction) {
        this.type = type;
        this.defaultValue = defaultValue;
        this.creatorFunction = creatorFunction;
        this.dataCreatorFunction = dataCreatorFunction;
    }

    public <T> T getDefault() {
        return (T)this.defaultValue;
    }

    public static PropertyType getFromType(Class<?> type) {
        for (PropertyType propertyType : VALUES) {
            if (type != propertyType.type) continue;
            return propertyType;
        }
        return null;
    }

    public PropertyData createData(short property, FriendlyByteBuf buffer) {
        return this.dataCreatorFunction.apply(property, buffer);
    }

    public ISyncableData create(Supplier<Object> supplier, Consumer<Object> consumer) {
        return this.creatorFunction.apply(supplier, consumer);
    }

    private static /* synthetic */ FloatingLong lambda$static$46(Supplier getter) {
        return (FloatingLong)getter.get();
    }

    private static /* synthetic */ BlockPos lambda$static$43(Supplier getter) {
        return (BlockPos)getter.get();
    }

    private static /* synthetic */ Frequency lambda$static$40(Supplier getter) {
        return (Frequency)getter.get();
    }

    private static /* synthetic */ SlurryStack lambda$static$37(Supplier getter) {
        return (SlurryStack)getter.get();
    }

    private static /* synthetic */ PigmentStack lambda$static$34(Supplier getter) {
        return (PigmentStack)getter.get();
    }

    private static /* synthetic */ InfusionStack lambda$static$31(Supplier getter) {
        return (InfusionStack)getter.get();
    }

    private static /* synthetic */ GasStack lambda$static$28(Supplier getter) {
        return (GasStack)getter.get();
    }

    private static /* synthetic */ FluidStack lambda$static$25(Supplier getter) {
        return (FluidStack)getter.get();
    }

    private static /* synthetic */ ItemStack lambda$static$22(Supplier getter) {
        return (ItemStack)getter.get();
    }

    private static /* synthetic */ short lambda$static$18(Supplier getter) {
        return (Short)getter.get();
    }

    private static /* synthetic */ long lambda$static$15(Supplier getter) {
        return (Long)getter.get();
    }

    private static /* synthetic */ int lambda$static$12(Supplier getter) {
        return (Integer)getter.get();
    }

    private static /* synthetic */ float lambda$static$9(Supplier getter) {
        return ((Float)getter.get()).floatValue();
    }

    private static /* synthetic */ double lambda$static$6(Supplier getter) {
        return (Double)getter.get();
    }

    private static /* synthetic */ byte lambda$static$3(Supplier getter) {
        return (Byte)getter.get();
    }

    private static /* synthetic */ boolean lambda$static$0(Supplier getter) {
        return (Boolean)getter.get();
    }

    static {
        VALUES = PropertyType.values();
    }
}

